module net.BurtonRadons.spyl.expressionMultiply;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.expressionBinary;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** A multiplication expression; "a * b". */
class MultiplyExpression : BinaryExpression
{
    /** Assign the parameters. */
    this (Mark mark, Expression a, Expression b)
    {
        super (mark, a, b);
    }
    
    override Value evaluate (Scope scope)
    {
        return a.evaluate (scope) * b.evaluate (scope);
    }
    
    override char [] toString ()
    {
        return subString (a) ~ " * " ~ subString (b);
    }
    
    override int precedence ()
    {
        return Precedence.Multiply;
    }
}
